module ScuffedHelperPushPuzzleBlock
using ..Ahorn, Maple

#define properties of entity
@mapdef Entity "ScuffedHelper/PushPuzzleBlock" PushPuzzleBlock(
    x::Integer, 
    y::Integer,
    #width::Integer=Maple.defaultBlockWidth, 
    #height::Integer=Maple.defaultBlockHeight,
    moveDistance::Integer = 32,
    r::Integer = 36,
    g::Integer = 8,
    b::Integer = 78,
    a::Float64 = 0.0,
    tiletype::String="3",
    index::Integer=0)

#save placements
const placements = Ahorn.PlacementDict(
    "Push Puzzle Block (Scuffed Helper)" => Ahorn.EntityPlacement(
        PushPuzzleBlock,
        "rectangle",
        Dict{String, Any}(),
        Ahorn.tileEntityFinalizer
    )
)

Ahorn.editingOptions(entity::PushPuzzleBlock) = Dict{String, Any}(
    "tiletype" => Ahorn.tiletypeEditingOptions()
)

#set minimum size
Ahorn.minimumSize(entity::PushPuzzleBlock) = 8, 8
#allow entity to be resizable
Ahorn.resizable(entity::PushPuzzleBlock) = true, true

#get selection box
function Ahorn.selection(entity::PushPuzzleBlock)
    x, y = Ahorn.position(entity)

    width = Int(get(entity.data, "width", 8))
    height = Int(get(entity.data, "height", 8))

    return Ahorn.Rectangle(x, y, width, height)
end

#render

function Ahorn.render(ctx::Ahorn.Cairo.CairoContext, entity::PushPuzzleBlock, room::Maple.Room)
    
    #Ahorn.drawRectangle(ctx, 0, 0, width, height, (0.0, 0.0, 0.0, 1.0), (0.0, 0.0, 0.0, 1.0))
    
end

function Ahorn.renderAbs(ctx::Ahorn.Cairo.CairoContext, entity::PushPuzzleBlock, room::Maple.Room) 
    x, y = Ahorn.position(entity)
    
    width = Int(get(entity.data, "width", 8))
    height = Int(get(entity.data, "height", 8))

    #draw outline
    Ahorn.set_antialias(ctx, 1)
    Ahorn.set_line_width(ctx, 1)

    #fillcolour = (0.2, 0.15, 0.8) * Int(get(entity.data, "index", 1)) / 10 + 0.3
    index = Int(get(entity.data, "index", 1))

    fillCol = 
        (Int(get(entity.data, "r", 36)) / 255, 
        Int(get(entity.data, "g", 8)) / 255, 
        Int(get(entity.data, "b", 78)) / 255, 
        Float64(get(entity.data, "a", 0.5)))
    #Ahorn.drawRectangle(ctx, 0, 0, width, height, (0.2, index/8, 0.8, 0.5), (0.0, 0.0, 0.0, 1.0))
    
    Ahorn.drawRectangle(ctx, x, y, width, height, fillCol, (0.0, 0.0, 0.0, 0.0))

    Ahorn.drawTileEntity(ctx, room, entity)

    

    
end

end