module ScuffedHelperMovableRespawn
using ..Ahorn, Maple

#define properties of entity
@mapdef Entity "ScuffedHelper/MovableRespawn" MovableRespawn(
    x::Integer, 
    y::Integer,
    flipped::Bool=false
    )

#save placements
const placements = Ahorn.PlacementDict(
    "Movable Player Spawn (Scuffed Helper)" => Ahorn.EntityPlacement(
        MovableRespawn
    )
)

#get selection box
function Ahorn.selection(entity::MovableRespawn)
    x, y = Ahorn.position(entity)

    return Ahorn.Rectangle(x - 12, y - 8, 24, 24)
end

#render

function Ahorn.render(ctx::Ahorn.Cairo.CairoContext, entity::MovableRespawn, room::Maple.Room)
    flip = Bool(get(entity.data, "flipped", false))
    if flip
        Ahorn.drawSprite(ctx, "ahorn/Movable Respawn/MovableSpawnIcon", 0, 0, sx=-1)
    else
        Ahorn.drawSprite(ctx, "ahorn/Movable Respawn/MovableSpawnIcon", 0, 0)
    end
end

end