module ScuffedHelperFourSurfaceWater
using ..Ahorn, Maple

#define properties of entity

#for each surface, define rays per pixel?
@mapdef Entity "ScuffedHelper/FourSurfaceWater" FourSurfaceWater(
    x::Integer, 
    y::Integer,
    width::Integer=Maple.defaultBlockWidth, 
    height::Integer=Maple.defaultBlockHeight,

    hasTop::Bool=true,
    hasBottom::Bool=true,
    hasLeft::Bool=true,
    hasRight::Bool=true,
    
    topRaysDensity::Float64=0.2,
    bottomRaysDensity::Float64=0.2,
    leftRaysDensity::Float64=0.2,
    rightRaysDensity::Float64=0.2,

    topRayColours::String="87cefa99",
    bottomRayColours::String="87cefa99",
    leftRayColours::String="87cefa99",
    rightRayColours::String="87cefa99",
    
    topSurfaceColour::String="87cefacc",
    bottomSurfaceColour::String="87cefacc",
    leftSurfaceColour::String="87cefacc",
    rightSurfaceColour::String="87cefacc",

    topRaysDensity::Integer=8,
    bottomRaysDensity::Integer=8,
    leftRaysDensity::Integer=8,
    rightRaysDensity::Integer=8,
    
    fillColour::String="87cefa4d")

#save placements
const placements = Ahorn.PlacementDict(
    "Four Surface Water (Scuffed Helper)" => Ahorn.EntityPlacement(
        FourSurfaceWater,
        "rectangle"
    )
)

Ahorn.editingOrder(entity::Maple.Entity) = String[
     "x", "y", 
     "height", "width", 
     "topSurfaceColour", "bottomSurfaceColour", 
     "topRayColours", "bottomRayColours", 
     "topRaysDensity", "bottomRaysDensity", 
     "leftSurfaceColour", "rightSurfaceColour", 
     "leftRayColours", "rightRayColours", 
     "leftRaysDensity", "rightRaysDensity", 
     "fillColour", 
     "hasTop", "hasBottom", "hasLeft", "hasRight"]

#set minimum size
Ahorn.minimumSize(entity::FourSurfaceWater) = 8, 8
#allow entity to be resizable
Ahorn.resizable(entity::FourSurfaceWater) = true, true

#get selection box
function Ahorn.selection(entity::FourSurfaceWater)
    x, y = Ahorn.position(entity)

    width = Int(get(entity.data, "width", 8))
    height = Int(get(entity.data, "height", 8))

    return Ahorn.Rectangle(x, y, width, height)
end

#render

function Ahorn.render(ctx::Ahorn.Cairo.CairoContext, entity::FourSurfaceWater, room::Maple.Room)
    width = Int(get(entity.data, "width", 8))
    height = Int(get(entity.data, "height", 8))


    #draw outline
    Ahorn.set_antialias(ctx, 1)
    Ahorn.set_line_width(ctx, 1)
    Ahorn.drawRectangle(ctx, 0, 0, width, height, (0.53, 0.81, 0.98, 0.3), (0.53, 0.81, 0.98, 0.8))
end

end