﻿using System;

namespace Celeste.Mod.MoreNeonline;

public class MoreNeonlineModule : EverestModule {
    public static MoreNeonlineModule Instance { get; private set; }

    public override Type SettingsType => typeof(MoreNeonlineModuleSettings);
    public static MoreNeonlineModuleSettings Settings => (MoreNeonlineModuleSettings) Instance._Settings;

    public MoreNeonlineModule()
    {
        Instance = this;
#if DEBUG
        // debug builds use verbose logging
        Logger.SetLogLevel(nameof(MoreNeonlineModule), LogLevel.Verbose);
#else
        // release builds use info logging to reduce spam in log files
        Logger.SetLogLevel(nameof(MoreNeonlineModule), LogLevel.Info);
#endif
    }

    public override void Load()
    {
        // TODO: apply any hooks that should always be active
        FileSelectNameColor.Load();
    }

    public override void Unload()
    {
        // TODO: unapply any hooks applied in Load()
        FileSelectNameColor.Unload();
    }
}
