module DSidesPlatinumDetachPlatberryTrigger

using ..Ahorn, Maple

@mapdef Trigger "PlatinumStrawberry/DetachPlatberryTrigger" DetachPlatBerryTrigger(x::Integer, y::Integer, width::Integer=Maple.defaultTriggerWidth, height::Integer=Maple.defaultTriggerHeight, nodes::Array{Tuple{Integer, Integer}, 1}=Tuple{Integer, Integer}[])

const placements = Ahorn.PlacementDict(
    "Detach Platinum Berry" => Ahorn.EntityPlacement(
        DetachPlatBerryTrigger,
        "rectangle",
        Dict{String, Any}(),
        function(trigger)
            trigger.data["nodes"] = [
                (Int(trigger.data["x"]) + Int(trigger.data["width"]) + 8, Int(trigger.data["y"])),
            ]
        end
    )
)

function Ahorn.nodeLimits(trigger::DetachPlatBerryTrigger)
    return 1, 1
end

end