module PlatBerryPlatinumStrawberry

using ..Ahorn, Maple

@mapdef Entity "PlatinumStrawberry/PlatinumStrawberry" PlatinumStrawberry(x::Integer, y::Integer, collectSound::String="Original", customCollectSound::String="")

const placements = Ahorn.PlacementDict(
    "Platinum Strawberry [PlatBerry Asset-Pack]" => Ahorn.EntityPlacement(
        PlatinumStrawberry
    )
)

const sprite = "SyrenyxPlatinumStrawberry/collectables/platinumberry/plat00.png"
const collectSoundOptions = ["Original", "Elaborate", "Minimalist", "Custom"]
const editingOptions = Dict{String, Any}(
    "collectSound" => ["Original", "Elaborate", "Minimalist", "Custom"]
)

Ahorn.editingOptions(entity::PlatinumStrawberry) = editingOptions

function Ahorn.selection(entity::PlatinumStrawberry)
    x, y = Ahorn.position(entity)
    return Ahorn.getSpriteRectangle(sprite, x, y)
end

Ahorn.render(ctx::Ahorn.Cairo.CairoContext, entity::PlatinumStrawberry, room::Maple.Room) = Ahorn.drawSprite(ctx, sprite, 0, 0)

end