function onEnter()
	-- This is the ending cutscene, stop the level timer now.
	getLevel():RegisterAreaComplete()
end

function onBegin()
	disableMovement()
	
	-- run to the left side of the wall
	runTo(15910)
	
	-- pause for dramatic effect
	wait(0.4)
	
	-- Dash in the direction you are facing
	setPlayerState(2)
	player:StartDash()
	
	-- commit screen shake (TODO sound)
	-- we commit small screen shake multiple times because calling the method once shakes the screen by 100x-screen-shake-variant-like amounts.
	for i=1,30,1 do
		celeste.Mod.IntoTheJungleCodeMod.IntoTheJungleCodeModule.DirectionalShakeRegardlessOfSetting(getLevel(), vector2(0, 1), 0.1)
		wait(0.1)
	end
	
	-- make all falling blocks... fall
	for i, fallingBlock in pairs(getAllEntities("Mod.JungleHelper.Entities.AutoFallingBlockDelayed")) do
		fallingBlock:ForceFall()
	end
	
	-- AAAAA

	wait(3)
end

function onEnd()
	completeArea()
end
