namespace Celeste.Mod.CelesteRace;

using System;
using Monocle;
using Microsoft.Xna.Framework;
using System.Runtime.CompilerServices;

public class CurrentPlayerDisplay : Entity
{

    public string CurrentRelay = "";
    public int drawTimer = 0;

	[MethodImpl(MethodImplOptions.NoInlining)]
	public CurrentPlayerDisplay()
	{
        Tag = Tags.HUD | Tags.Global | Tags.PauseUpdate | Tags.TransitionUpdate;
		Depth = -500;
        Y = 60;
        X = 60;
	}


	[MethodImpl(MethodImplOptions.NoInlining)]
	public override void Update()
	{
        if (drawTimer > 0)
        {
            drawTimer--;
        }
        switch(CelesteRaceModule.ModuleSettings.RelayPosition)
        {
            case RelayDisplayPosition.TopLeft:
                Position = new Vector2(60, 60);
                break;
            case RelayDisplayPosition.TopRight:
                Position = new Vector2(Engine.Width - 60, 60);
                break;
            case RelayDisplayPosition.BottomLeft:
                Position = new Vector2(60, Engine.Height - 60);
                break;
            case RelayDisplayPosition.BottomRight:
                Position = new Vector2(Engine.Width - 60, Engine.Height - 60);
                break;
            case RelayDisplayPosition.Center:
                Position = new Vector2(Engine.Width / 2, Engine.Height / 2);
                break;
        }
		base.Update();
	}

    public void SetRelay(string relay)
    {
        CurrentRelay = relay;
        drawTimer = CelesteRaceModule.ModuleSettings.RelayDisplayFrames;
    }

	[MethodImpl(MethodImplOptions.NoInlining)]
	public override void Render()
	{
        Level level = base.Scene as Level;
        Session session = level.Session;
		PixelFont font = Dialog.Languages["english"].Font;
		float fontFaceSize = Dialog.Languages["english"].FontFaceSize * CelesteRaceModule.ModuleSettings.RelayDisplaySize / 10f;
        float alpha = Math.Min(1f, drawTimer * 2f / CelesteRaceModule.ModuleSettings.RelayDisplayFrames);
        switch (CelesteRaceModule.ModuleSettings.RelayPosition)
        {
            case RelayDisplayPosition.TopLeft:
                font.DrawOutline(fontFaceSize, CurrentRelay, new Vector2(X,Y), new Vector2(0f, 0f), Vector2.One, Color.White * alpha, 2f, Color.Black * alpha);
                break;
            case RelayDisplayPosition.TopRight:
                font.DrawOutline(fontFaceSize, CurrentRelay, new Vector2(X,Y), new Vector2(1f, 0f), Vector2.One, Color.White * alpha, 2f, Color.Black * alpha);
                break;
            case RelayDisplayPosition.BottomLeft:
                font.DrawOutline(fontFaceSize, CurrentRelay, new Vector2(X,Y), new Vector2(0f, 1f), Vector2.One, Color.White * alpha, 2f, Color.Black * alpha);
                break;
            case RelayDisplayPosition.BottomRight:
                font.DrawOutline(fontFaceSize, CurrentRelay, new Vector2(X,Y), new Vector2(1f, 1f), Vector2.One, Color.White * alpha, 2f, Color.Black * alpha);
                break;
            case RelayDisplayPosition.Center:
                font.DrawOutline(fontFaceSize, CurrentRelay, new Vector2(X,Y), new Vector2(0.5f, 0.5f), Vector2.One, Color.White * alpha, 2f, Color.Black * alpha);
                break;
        }
	}
}