namespace Celeste.Mod.CelesteRace;

using System;
using System.Collections.Generic;
using System.IO;
using Monocle;

public class RelayDisplaySettings {
    public string Name { get; set; }
    public RelaySettings Settings { get; set; }

}
public enum RelayDisplayPosition {
    None,
    TopLeft,
    TopRight,
    BottomLeft,
    BottomRight,
    Center
}
public class RelaySettings
{
    public ScreenshakeAmount ScreenShake = ScreenshakeAmount.Half;
    public RumbleAmount Rumble = RumbleAmount.On;
    public GrabModes GrabMode;
    public CrouchDashModes CrouchDashMode;
    public int MusicVolume = 10;
    public int SFXVolume = 10;
    public Binding Left = new Binding();
    public Binding Right = new Binding();
    public Binding Down = new Binding();
    public Binding Up = new Binding();
    public Binding MenuLeft = new Binding();
    public Binding MenuRight = new Binding();
    public Binding MenuDown = new Binding();
    public Binding MenuUp = new Binding();
    public Binding Grab = new Binding();
    public Binding Jump = new Binding();
    public Binding Dash = new Binding();
    public Binding Talk = new Binding();
    public Binding Pause = new Binding();
    public Binding Confirm = new Binding();
    public Binding Cancel = new Binding();
    public Binding Journal = new Binding();
    public Binding QuickRestart = new Binding();
    public Binding DemoDash = new Binding();
    public Binding RightMoveOnly = new Binding();
    public Binding LeftMoveOnly = new Binding();
    public Binding UpMoveOnly = new Binding();
    public Binding DownMoveOnly = new Binding();
    public Binding RightDashOnly = new Binding();
    public Binding LeftDashOnly = new Binding();
    public Binding UpDashOnly = new Binding();
    public Binding DownDashOnly = new Binding();

    public static void cloneBinding(Binding orig, Binding clone) {
        clone.Keyboard.Clear();
        foreach (Microsoft.Xna.Framework.Input.Keys key in orig.Keyboard) {
            clone.Keyboard.Add(key);
        }
        clone.Controller.Clear();
        foreach (Microsoft.Xna.Framework.Input.Buttons button in orig.Controller) {
            clone.Controller.Add(button);
        }
        clone.Mouse.Clear();
        foreach (MInput.MouseData.MouseButtons button in orig.Mouse) {
            clone.Mouse.Add(button);
        }
    }
    public RelaySettings(Settings orig) {
        ScreenShake = orig.ScreenShake;
        Rumble = orig.Rumble;
        GrabMode = orig.GrabMode;
        CrouchDashMode = orig.CrouchDashMode;
        MusicVolume = orig.MusicVolume;
        SFXVolume = orig.SFXVolume;
        cloneBinding(orig.Left, Left);
        cloneBinding(orig.Right, Right);
        cloneBinding(orig.Down, Down);
        cloneBinding(orig.Up, Up);
        cloneBinding(orig.MenuLeft, MenuLeft);
        cloneBinding(orig.MenuRight, MenuRight);
        cloneBinding(orig.MenuDown, MenuDown);
        cloneBinding(orig.MenuUp, MenuUp);
        cloneBinding(orig.Grab, Grab);
        cloneBinding(orig.Jump, Jump);
        cloneBinding(orig.Dash, Dash);
        cloneBinding(orig.Talk, Talk);
        cloneBinding(orig.Pause, Pause);
        cloneBinding(orig.Confirm, Confirm);
        cloneBinding(orig.Cancel, Cancel);
        cloneBinding(orig.Journal, Journal);
        cloneBinding(orig.QuickRestart, QuickRestart);
        cloneBinding(orig.DemoDash, DemoDash);
        cloneBinding(orig.RightMoveOnly, RightMoveOnly);
        cloneBinding(orig.LeftMoveOnly, LeftMoveOnly);
        cloneBinding(orig.UpMoveOnly, UpMoveOnly);
        cloneBinding(orig.DownMoveOnly, DownMoveOnly);
        cloneBinding(orig.RightDashOnly, RightDashOnly);
        cloneBinding(orig.LeftDashOnly, LeftDashOnly);
        cloneBinding(orig.UpDashOnly, UpDashOnly);
        cloneBinding(orig.DownDashOnly, DownDashOnly);
    }
    public RelaySettings() {
    }
    public void setSettings() {
        Settings.Instance.ScreenShake = ScreenShake;
        Settings.Instance.Rumble = Rumble;
        Settings.Instance.GrabMode = GrabMode;
        Settings.Instance.CrouchDashMode = CrouchDashMode;
        Settings.Instance.MusicVolume = MusicVolume;
        Settings.Instance.SFXVolume = SFXVolume;
        cloneBinding(Left, Settings.Instance.Left);
        cloneBinding(Right, Settings.Instance.Right);
        cloneBinding(Down, Settings.Instance.Down);
        cloneBinding(Up, Settings.Instance.Up);
        cloneBinding(MenuLeft, Settings.Instance.MenuLeft);
        cloneBinding(MenuRight, Settings.Instance.MenuRight);
        cloneBinding(MenuDown, Settings.Instance.MenuDown);
        cloneBinding(MenuUp, Settings.Instance.MenuUp);
        cloneBinding(Grab, Settings.Instance.Grab);
        cloneBinding(Jump, Settings.Instance.Jump);
        cloneBinding(Dash, Settings.Instance.Dash);
        cloneBinding(Talk, Settings.Instance.Talk);
        cloneBinding(Pause, Settings.Instance.Pause);
        cloneBinding(Confirm, Settings.Instance.Confirm);
        cloneBinding(Cancel, Settings.Instance.Cancel);
        cloneBinding(Journal, Settings.Instance.Journal);
        cloneBinding(QuickRestart, Settings.Instance.QuickRestart);
        cloneBinding(DemoDash, Settings.Instance.DemoDash);
        cloneBinding(RightMoveOnly, Settings.Instance.RightMoveOnly);
        cloneBinding(LeftMoveOnly, Settings.Instance.LeftMoveOnly);
        cloneBinding(UpMoveOnly, Settings.Instance.UpMoveOnly);
        cloneBinding(DownMoveOnly, Settings.Instance.DownMoveOnly);
        cloneBinding(RightDashOnly, Settings.Instance.RightDashOnly);
        cloneBinding(LeftDashOnly, Settings.Instance.LeftDashOnly);
        cloneBinding(UpDashOnly, Settings.Instance.UpDashOnly);
        cloneBinding(DownDashOnly, Settings.Instance.DownDashOnly);
    }

}

public static class SettingSerializer
{
    public static string SerializeToYaml<T>(T obj)
    {
        var serializer = new YamlDotNet.Serialization.SerializerBuilder().Build();
        return serializer.Serialize(obj);
    }
    public static T DeserializeFromYaml<T>(string yaml)
    {
        var deserializer = new YamlDotNet.Serialization.DeserializerBuilder().Build();
        return deserializer.Deserialize<T>(yaml);
    }
}