

using System.Collections.Generic;
using System.IO;
using Celeste.Mod.UI;
using YamlDotNet.Serialization;

namespace Celeste.Mod.CelesteRace;

public class CelesteRaceModuleSettings : EverestModuleSettings
{
    public CelesteRaceModuleSettings()
    {
    }
    public bool Enabled { get; set; } = true;
    public ButtonBinding NextSettings { get; set; } = new ButtonBinding();
    public ButtonBinding PreviousSettings { get; set; } = new ButtonBinding();
    
    [SettingName("Relay After X Deaths")]
    [SettingRange(0, 100)]
    public int RelayAfterXDeaths { get; set; } = 0;
    public RelayDisplayPosition RelayPosition { get; set; } = RelayDisplayPosition.TopLeft;
    [SettingRange(0, 300, true)]
    public int RelayDisplayFrames { get; set; } = 20;
    [SettingRange(0, 30)]
    public int RelayDisplaySize { get; set; } = 7;

    public List<RelayDisplaySettings> RelaySettings {get; set; } = [];

    
    public void CreateRelaySettingsEntry(TextMenu menu, bool inGame)
    {
        new RelayDisplayHandler(menu, inGame, this);
    }
}


public class RelayDisplayHandler
{
    private int currentIndex = 0;

    private void ChangeName(TextMenu menu, bool inGame, CelesteRaceModuleSettings settings)
    {
        if (inGame)
        {
            return;
        }
        string tempname = settings.RelaySettings[currentIndex].Name;
        menu.SceneAs<Overworld>().Goto<OuiModOptionString>().Init<OuiModOptions>(
            settings.RelaySettings[currentIndex].Name,
            v =>
            {
                tempname = v;
            },
            v =>
            {
                if (v == true)
                {
                    settings.RelaySettings[currentIndex].Name = tempname;
                    saveSettings(settings);
                }
            },
            24,
            1
        );

    }
    
    public void saveSettings(CelesteRaceModuleSettings settings)
    {
        //CelesteRaceModule.SaveData.RelaySettingString = SettingSerializer.SerializeToYaml(settings.RelaySettings);
    }

    public RelayDisplayHandler(TextMenu menu, bool inGame, CelesteRaceModuleSettings settings)
    {
        TextMenu.Slider indexDisplay = new TextMenu.Slider("Relay Index", (i) => { return i.ToString(); }, 0, settings.RelaySettings.Count - 1, currentIndex);
        TextMenu.Button nameButton = new TextMenu.Button("Name: " + settings.RelaySettings[currentIndex].Name);
        menu.Add(new TextMenu.SubHeader("Relay Index"));
        nameButton.Pressed(() =>
        {
            ChangeName(menu, inGame, settings);
        });
        indexDisplay.Change((i) =>
        {
            currentIndex = i;
            nameButton.Label = "Name: " + settings.RelaySettings[currentIndex].Name;
        });
        menu.Add(new TextMenu.Button("Add Relay")
        .Pressed(() =>
        {
            RelayDisplaySettings rds = new RelayDisplaySettings
            {
                Name = "Relay " + (settings.RelaySettings.Count + 1),
                Settings = new RelaySettings(Settings.Instance)
            };
            settings.RelaySettings.Add(rds);
            currentIndex = settings.RelaySettings.Count - 1;
            indexDisplay.Add(currentIndex.ToString(), currentIndex, true);
            if (inGame)
            {
                nameButton.Label = "Name: " + settings.RelaySettings[currentIndex].Name;
            }
            ChangeName(menu, inGame, settings);
            saveSettings(settings);
        }));
        menu.Add(indexDisplay);
        menu.Add(nameButton);
        menu.Add(new TextMenu.Button("Load Relay")
        .Pressed(() =>
        {
            settings.RelaySettings[currentIndex].Settings.setSettings();
        }));
        menu.Add(new TextMenu.Button("Update Relay")
        .Pressed(() =>
        {
            settings.RelaySettings[currentIndex].Settings = new RelaySettings(Settings.Instance);
            saveSettings(settings);
        }));
        menu.Add(new TextMenu.Button("Move Relay Forward")
        .Pressed(() =>{
            if (currentIndex <= 0)
            {
                return;
            }
            RelayDisplaySettings temp = settings.RelaySettings[currentIndex];
            settings.RelaySettings[currentIndex] = settings.RelaySettings[currentIndex - 1];
            settings.RelaySettings[currentIndex - 1] = temp;
            currentIndex--;
            indexDisplay.PreviousIndex = (indexDisplay.Index = currentIndex);
            nameButton.Label = "Name: " + settings.RelaySettings[currentIndex].Name;
            saveSettings(settings);
        }));
        menu.Add(new TextMenu.Button("Move Relay Backward")
        .Pressed(() =>
        {
            if (currentIndex >= settings.RelaySettings.Count - 1)
            {
                return;
            }
            RelayDisplaySettings temp = settings.RelaySettings[currentIndex];
            settings.RelaySettings[currentIndex] = settings.RelaySettings[currentIndex + 1];
            settings.RelaySettings[currentIndex + 1] = temp;
            currentIndex++;
            indexDisplay.PreviousIndex = (indexDisplay.Index = currentIndex);
            nameButton.Label = "Name: " + settings.RelaySettings[currentIndex].Name;
            saveSettings(settings);
        }));
        menu.Add(new TextMenu.Button("Delete Relay")
        .Pressed(() =>
        {
            if (settings.RelaySettings.Count <= 1)
            {
                return;
            }
            settings.RelaySettings.RemoveAt(currentIndex);
            indexDisplay.Values.RemoveAt(indexDisplay.Values.Count - 1);
            if (currentIndex >= settings.RelaySettings.Count)
            {
                currentIndex = settings.RelaySettings.Count - 1;
                indexDisplay.PreviousIndex = (indexDisplay.Index = currentIndex);
            }
            nameButton.Label = "Name: " + settings.RelaySettings[currentIndex].Name;
            saveSettings(settings);
            
        }));
    }
}
