﻿namespace Celeste.Mod.CelesteRace;

using System;
using Microsoft.Xna.Framework;
using Monocle;
using System.IO;
using System.Collections.Generic;

public class CelesteRaceModule : EverestModule {
    public static CelesteRaceModule Instance { get; private set; }

    public override Type SettingsType => typeof(CelesteRaceModuleSettings);
    public static CelesteRaceModuleSettings ModuleSettings => (CelesteRaceModuleSettings) Instance._Settings;
    
    public override Type SessionType => typeof(CelesteRaceModuleSession);
    public static CelesteRaceModuleSession Session => (CelesteRaceModuleSession) Instance._Session;

    public override Type SaveDataType => typeof(CelesteRaceModuleSaveData);
    public static CelesteRaceModuleSaveData SaveData => (CelesteRaceModuleSaveData) Instance._SaveData;

    public CelesteRaceModule() {
        Instance = this;
#if DEBUG
        // debug builds use verbose logging
        Logger.SetLogLevel(nameof(CelesteRaceModule), LogLevel.Verbose);
#else
        // release builds use info logging to reduce spam in log files
        Logger.SetLogLevel(nameof(CelesteRaceModule), LogLevel.Info);
#endif
    }

    public override void Load() {
        On.Celeste.LevelLoader.LoadingThread_Safe += LevelLoader_LoadingThread;
        On.Celeste.Player.Die += Player_Die;
        On.Celeste.Player.Update += Player_Update;
        if (ModuleSettings.RelaySettings.Count <= 0)
        {
            RelayDisplaySettings rds = new RelayDisplaySettings
            {
                Name = "Relay 1",
                Settings = new RelaySettings(Settings.Instance)
            };
            ModuleSettings.RelaySettings.Add(rds);
        }

    }

    private void LevelLoader_LoadingThread(On.Celeste.LevelLoader.orig_LoadingThread_Safe orig, LevelLoader self)
    {
        self.Level.Add(currentPlayerDisplay = new CurrentPlayerDisplay());
        orig(self);
    }


    public CurrentPlayerDisplay currentPlayerDisplay;

    public override void Unload() {
        On.Celeste.LevelLoader.LoadingThread_Safe -= LevelLoader_LoadingThread;
        On.Celeste.Player.Die -= Player_Die;
        On.Celeste.Player.Update -= Player_Update;
    }

    public int currentSettingsIndex = 0;
    private void Player_Update(On.Celeste.Player.orig_Update orig, Player self)
    {
        orig(self);
        if (ModuleSettings.NextSettings.Pressed) {
            nextSettings();
        }
    }

    public int deathCount = 0;
    private PlayerDeadBody Player_Die(On.Celeste.Player.orig_Die orig, Player self, Vector2 direction, bool evenIfInvincible, bool registerDeathInStats)
    {
        deathCount++;
        if (ModuleSettings.RelayAfterXDeaths > 0 && deathCount >= ModuleSettings.RelayAfterXDeaths) {
            nextSettings();
            deathCount = 0;
        }
        return orig(self, direction, evenIfInvincible, registerDeathInStats);
    }
    public void nextSettings() {
        if(ModuleSettings.RelaySettings.Count <= 1 || !ModuleSettings.Enabled)
        {
            return;
        }
        currentSettingsIndex++;
        if (currentSettingsIndex >= ModuleSettings.RelaySettings.Count) {
            currentSettingsIndex = 0;
        }
        ModuleSettings.RelaySettings[currentSettingsIndex].Settings.setSettings();
        currentPlayerDisplay.SetRelay(ModuleSettings.RelaySettings[currentSettingsIndex].Name);
    }
}
