#define DECLARE_TEXTURE(Name, index) \
    texture Name: register(t##index); \
    sampler Name##Sampler: register(s##index)

#define SAMPLE_TEXTURE(Name, texCoord) tex2D(Name##Sampler, texCoord)

uniform float Time; // level.TimeActive
uniform float2 CamPos; // level.Camera.Position
uniform float2 Dimensions; // new floattor2(320, 180)

uniform float4x4 TransformMatrix;
uniform float4x4 ViewMatrix;

DECLARE_TEXTURE(text, 0);

float rand(float2 n) { 
	return frac(sin(dot(n, float2(12.9898, 4.1414))) * 43758.5453);
}

float4 lerp(float4 a, float4 b, float t) {
    return a + (b - a) * t;
}

float wave(float x) {
    return (sin(8.0 * x + Time * 0.25) + sin(16.0 * x - Time) * 0.5) * 0.05 + 0.5;
}

float4 clean(float4 color) {
    float4 a = float4(clamp(color.r, 0.0, 1.0), clamp(color.g, 0.0, 1.0), clamp(color.b, 0.0, 1.0), clamp(color.a, 0.0, 1.0));
    
    a.rgb *= a.a;
    
    return a;
}

float4 d(float dist, float x, float r) {
    dist *= (sin(x * 10.0 - Time + r) * 0.25 + 1.0);

    float gOffset = sin(x * 20.0 + Time) + sin(x * 30.0 - Time + r);

    float4 col1 = float4(0.1, 0.9 + gOffset * 0.05, 0.2 + gOffset * 0.1, 1);
    float4 col2 = float4(0.2, 0.8 + gOffset * 0.1, 1.0, 0.5);

    if(dist > 0.0) {
        return clean(lerp(col1, col2, 4.0 * dist));
    }
    
    return clean(lerp(col1, float4(0,0,0,0), min(-dist * 10.0, 1.0)));
}

float4 SpritePixelShader(float2 uv : TEXCOORD0) : COLOR0
{
    float2 vuv = uv + CamPos/Dimensions;

    float4 fragColor = float4(0,0,0,0);
    
    fragColor += 0.7 * d(1.0 - uv.y * 2.5 - wave(1    * uv.x + 2632.32), uv.x, 0.0);
    fragColor += 0.5 * d(2.1 - uv.y * 4.0 - wave(-1.5 * uv.x + 5323.93), uv.x * 0.9 + 34534.2, 36.0);
    // fragColor += 0.8 * d((uv.y * 4.0 - wave(uv.x + 1000.0)) * 2.0 + 0.5, uv.x * 2.0);
    
    return fragColor;
}

void SpriteVertexShader(inout float4 color    : COLOR0,
                        inout float2 texCoord : TEXCOORD0,
                        inout float4 position : SV_Position)
{
    position = mul(position, ViewMatrix);
    position = mul(position, TransformMatrix);
}


technique Shader
{
    pass pass0
    {
        VertexShader = compile vs_3_0 SpriteVertexShader();
        PixelShader = compile ps_3_0 SpritePixelShader();
    }
}