#define DECLARE_TEXTURE(Name, index) \
    texture Name: register(t##index); \
    sampler Name##Sampler: register(s##index)

#define SAMPLE_TEXTURE(Name, texCoord) tex2D(Name##Sampler, texCoord)

uniform float Time; // level.TimeActive
uniform float2 CamPos; // level.Camera.Position
uniform float2 Dimensions; // new floattor2(320, 180)

uniform float4x4 TransformMatrix;
uniform float4x4 ViewMatrix;

DECLARE_TEXTURE(text, 0);

float a(float dist) {
    return max(1.0 - dist * 40.0, 0.0) + min(0.0033/dist, 0.1);
}

float4 lerp4(float4 a, float4 b, float t) {
    return a + (b - a) * t;
}

float rand(float2 n) { 
	return frac(sin(dot(n, float2(12.9898, 4.1414))) * 43758.5453);
}

#define LENGTH 28
#define PI 3.1415926535

static const float2 points[LENGTH] = {
    float2(0, 1.5),
    float2(1.0, 1.7),
    float2(2.5, 1.6),
    float2(4, 1.95),
    float2(6, 1.5),
    float2(6.8, 1.45),
    float2(8, 1.7),
    float2(10, 1.4),
    float2(14, 1.8),
    float2(16, 1.3),
    float2(17.5, 1.6),
    float2(19, 1.3),
    float2(20.5, 1.6),
    float2(23, 1.9),
    float2(24, 1.5),
    float2(25, 1.7),
    float2(27, 1.3),
    float2(29.75, 1.9),
    float2(31, 1.7),
    float2(32, 1.45),
    float2(33, 1.7),
    float2(35, 1.3),
    float2(38, 1.9),
    float2(41, 1.1),
    float2(43, 1.0),
    float2(45, 1.9),
    float2(47, 1.5),
    float2(50, 0.2),
};

float interpolate(float2 a, float2 b, float t) {
    return (cos(PI * (t - a.x) / (a.x - b.x)) * 0.5 + 0.5) * (a.y - b.y) + b.y;
}

float curve(float x) {
    float2 start = float2(-100, 0);
    float2 end = float2(-99, 0);

    for(int index = 0; index < LENGTH - 1; index++) {
        float2 first = points[index];
        float2 second = points[index+1];

        if(x >= first.x) {
            start = first;
            end = second;
        }
    }

    return interpolate(start,end,x);
}

float4 SpritePixelShader(float2 uv : TEXCOORD0) : COLOR0
{
    float2 vuv = uv + CamPos/Dimensions;

    // float g = 0.0f;

    // for(int ball = 0; ball < LENGTH; ball++) {
    //     float dist = distance(vuv, points[ball]);

    //     if(dist < 0.05f) {
    //         g += 1.0;

    //         break;
    //     }
    // }

    float p = curve(vuv.x);

    // if(distance(p, vuv.y) < 0.01) {
    //     return float4(1-g,g,0,1);
    // }

    float4 color = float4(0,0,0,0);
    
    for(float j = 0.0; j < 10.0; j++) {
        float phaseMult = 1.0 + rand(float2(j,j));
        float amplitudeOffset = pow(rand((float2(j,j*j)) - 0.5) * 1.2, 2.0);
        float sizeMult = 1.0 + rand(float2(j*j,j)) * 0.3;
        float speed = 1.0;
        float start = 247.27;
    
        float v = sin(vuv.x - (Time + start) * phaseMult * speed) * (0.1 + amplitudeOffset * 0.1);
        
        color += lerp4(float4(0.4, 0.3, 0.65, 1), float4(0.0, 0.9, 0.6, 1), rand(float2(j,sin(j)))) * a(distance(v,vuv.y - p) / sizeMult);
    }
    
    return color * float4(1,1,1,0.1);
}

void SpriteVertexShader(inout float4 color    : COLOR0,
                        inout float2 texCoord : TEXCOORD0,
                        inout float4 position : SV_Position)
{
    position = mul(position, ViewMatrix);
    position = mul(position, TransformMatrix);
}


technique Shader
{
    pass pass0
    {
        VertexShader = compile vs_3_0 SpriteVertexShader();
        PixelShader = compile ps_3_0 SpritePixelShader();
    }
}