#define DECLARE_TEXTURE(Name, index) \
    texture Name: register(t##index); \
    sampler Name##Sampler: register(s##index)

#define SAMPLE_TEXTURE(Name, texCoord) tex2D(Name##Sampler, texCoord)
#define MAX_COLORS 2

uniform float Time; // level.TimeActive
uniform float2 CamPos; // level.Camera.Position
uniform float2 Dimensions; // new Vector2(320, 180)
uniform bool Photosensitive;
uniform float4 Colors[MAX_COLORS];

uniform float4x4 TransformMatrix;
uniform float4x4 ViewMatrix;

DECLARE_TEXTURE(text, 0);


float3 gradiant (float x)
{
    float x2 = 1.0-(x/0.70710678119);
    
    return lerp(Colors[0], Colors[1], frac(x2));
}

float4 SpritePixelShader(float2 uv : TEXCOORD0) : COLOR0
{
    float2 worldPos = (uv * Dimensions) + CamPos;
    float4 color = SAMPLE_TEXTURE(text, uv);

    if (color.a == 0) return color;
    // Normalized pixel coordinates (from 0 to 1)
    //vec2 uv = (fragCoord * 2.0 - iResolution.xy) / iResolution.x;
    //+ float2(320*cos(Time), -320*sin(Time)

    // Output to screen
    float4 finalColor = float4(gradiant(sqrt(pow(distance(uv.x, 0.5),2)+pow(distance(uv.y, 0.5),2)))*0.5,1);
    return lerp(color, finalColor, 0.7);
}

void SpriteVertexShader(inout float4 color    : COLOR0,
                        inout float2 texCoord : TEXCOORD0,
                        inout float4 position : SV_Position)
{
    position = mul(position, ViewMatrix);
    position = mul(position, TransformMatrix);
}

technique Shader
{
    pass pass0
    {
        VertexShader = compile vs_3_0 SpriteVertexShader();
        PixelShader = compile ps_3_0 SpritePixelShader();
    }
}
