local badeline
local BadelineDummy = require("#celeste.BadelineDummy")

-- Coroutine that does all the cutscene magic.
-- This invloves stuff like walking, jumping, displaying text boxes, etc.
local function onBegin()
	if not getFlag("flccwizardofwit/waterrising") then
		disableMovement()
		wait(0.2)
		playSprite("lookUp")
		say("flcc_wizardofwit_waterrising")
		setFlag("flccwizardofwit/waterrising")
		say("flcc_wizardofwit_waterrising2")
		setFlag("flccwizardofwit/waterrising2")
		wait(0.5)
		setFlag("flccwizardofwit/waterrising3")
		wait(0.5)
		setFlag("flccwizardofwit/waterrising4")
		wait(0.5)
		setFlag("flccwizardofwit/waterrising5")
		wait(0.5)
		setFlag("flccwizardofwit/waterrising6")
		say("flcc_wizardofwit_waterrising3")
		setFlag("flccwizardofwit/waterrising7")
		playMusic("music_cliffside_heavywinds")
		enableMovement()
	end
end

-- Function, no yielding actions allowed.
-- That means no walking, waiting etc.
-- Only "clean up" actions.
local function onEnd(level, wasSkipped)
    if wasSkipped then
		enableMovement()
		setFlag("flccwizardofwit/waterrising")
		setFlag("flccwizardofwit/waterrising2")
		setFlag("flccwizardofwit/waterrising3")
		setFlag("flccwizardofwit/waterrising4")
		setFlag("flccwizardofwit/waterrising5")
		setFlag("flccwizardofwit/waterrising6")
		setFlag("flccwizardofwit/waterrising7")
		playMusic("music_cliffside_heavywinds")
		endCutscene()
    end
end

function playSprite(sprite, duration)
	player.DummyAutoAnimate = false
	player.Sprite:Play(sprite, false, false)
	if (duration) then
		wait(duration)
		player.DummyAutoAnimate = true
	end
end

return onBegin, onEnd