local badeline
local BadelineDummy = require("#celeste.BadelineDummy")

-- Coroutine that does all the cutscene magic.
-- This invloves stuff like walking, jumping, displaying text boxes, etc.
local function onBegin()
	if not getFlag("flccwatersource/water") then
		player.ForceCameraUpdate = true
		setFlag("flccwatersource/water")
		disableMovement()
		waitUntilOnGround()
		say("flcc_wizardofwit_waterhere")
		wait(1)
		playSprite("lookUp")
		wait(1)
		say("flcc_wizardofwit_waterabove")
		enableMovement()
	end
end

-- Function, no yielding actions allowed.
-- That means no walking, waiting etc.
-- Only "clean up" actions.
local function onEnd(level, wasSkipped)
    if wasSkipped then
		enableMovement()
		endCutscene()
    end
end

function playSprite(sprite, duration)
	player.DummyAutoAnimate = false
	player.Sprite:Play(sprite, false, false)
	if (duration) then
		wait(duration)
		player.DummyAutoAnimate = true
	end
end

return onBegin, onEnd