
-- Coroutine that does all the cutscene magic.
-- This invloves stuff like walking, jumping, displaying text boxes, etc.
local function onTalk()
	say("flcc_collab_info")
	endCutscene()
end

-- Function, no yielding actions allowed.
-- That means no walking, waiting etc.
-- Only "clean up" actions.
local function onEnd(level, wasSkipped)
    if wasSkipped then
		enableMovement()
		endCutscene()
    end
end

function playSprite(sprite, duration)
	player.DummyAutoAnimate = false
	player.Sprite:Play(sprite, false, false)
	if (duration) then
		wait(duration)
		player.DummyAutoAnimate = true
	end
end

return onBegin, onEnd