module NeihraHelperAudioSource

using ..Ahorn, Maple

@mapdef Trigger "NeihraHelper/AudioSource" AudioSource(
    x::Integer, 
    y::Integer, 
    width::Integer = Maple.defaultTriggerWidth, 
    height::Integer = Maple.defaultTriggerHeight,
    event::String="",
)

const placements = Ahorn.PlacementDict(
    "Audio Source (Neihra Helper)" => Ahorn.EntityPlacement(
        AudioSource,
        "rectangle",
        Dict{String, Any}(),
        function(entity)
            x, y = Ahorn.position(entity)
            width = Int(get(entity.data, "width", 8))
            height = Int(get(entity.data, "height", 8))
        end
    ),
)

end