module NeihraHelperCustomSpinner

using ..Ahorn, Maple

@mapdef Entity "NeihraHelper/CustomSpinner" Controller(
    x::Int,
    y::Int,
    attachToSolid::Bool=false,
    changeColorFlag::String="",
    hexColor1::String="FFFFFF",
    hexColor2::String="222222",
    borderHexColor1::String="000000",
    borderHexColor2::String="000000"
)

const placements = Ahorn.PlacementDict(
    "Custom Spinner (NeihraHelper)" => Ahorn.EntityPlacement(
        Controller,
    ),
)

const sprite = "danger/NeihraHelper/customSpinner/white/fg_white00"

Ahorn.render(ctx::Ahorn.Cairo.CairoContext, entity::Controller) = Ahorn.drawSprite(ctx, sprite, 0, 0)

Ahorn.selection(entity::Controller) = Ahorn.getSpriteRectangle(sprite, Ahorn.position(entity)...)

end

