function playSprite(sprite, duration)
    player.DummyAutoAnimate = false
    player.Sprite:Play(sprite, false, false)
    if (duration) then
      wait(duration)
      player.DummyAutoAnimate = true
    end
  end

  local function doFadeWipe(state)
    fadeWipe = celeste.FadeWipe(engine.Scene, state)
    engine.Scene:Add(fadeWipe)
    fadeWipe.duration = 20;
    fadeWipe.EndTimer = 5;
end

  -- Parallel coroutine wrapper
local monocle = require("#monocle")
local coroutineEntity = monocle.Entity()


function onBegin()
    waitUntilOnGround()
    setFlag("flag_blackScreen", false)
    disableMovement()
    walkTo(4275, false, 0.7)
    wait(0.1)
    player.Facing = getEnum("Celeste.Facings", "Right")
    wait(0.2)
    player.DummyAutoAnimate = false
    local level = getLevel()
    level:add(coroutineEntity)
    coroutineEntity:add(monocle.Coroutine(level:ZoomTo(vector2(156, 92), 1.2, 2)))
    coroutineEntity:add(monocle.Coroutine(wait(0.5)))
    coroutineEntity:add(monocle.Coroutine(player.Sprite:Play("sitDown", false, false)))
    wait(5)
    say("DIA_COMEANDSEE_ENDING_A")
    wait(3)
    say("DIA_COMEANDSEE_ENDING_B")
    wait(3)
    say("DIA_COMEANDSEE_ENDING_C")
    wait(3)
    say("DIA_COMEANDSEE_ENDING_D")
    wait(5)
    doFadeWipe(false)
    wait(10)
    setFlag("flag_blackScreen", true)
    completeArea()
end

function onEnd(room, wasSkipped)
    if wasSkipped then
        completeArea()
    end
    
end