local monocle = require("#monocle")
local coroutineEntity = monocle.Entity()

function playSprite(sprite, duration)
    player.DummyAutoAnimate = false
    player.Sprite:Play(sprite, false, false)
    if (duration) then
      wait(duration)
      player.DummyAutoAnimate = true
    end
  end




function onBegin()
    disableMovement()
    player.Facing = getEnum("Celeste.Facings", "Right")
    wait(0.1)
    coroutine.yield(engine.Scene:ZoomTo(vector2(250, 120), 2.5, 0.01))
    wait(0.02)
    coroutine.yield(engine.Scene:ZoomBack(0))
    wait(0.06)
    coroutine.yield(engine.Scene:ZoomTo(vector2(250, 120), 2.5, 0.01))
    wait(0.1)
    coroutine.yield(engine.Scene:ZoomBack(0))
    setFlag("flag_corpseOn", true)
    wait(1)
    player.DummyAutoAnimate = false
    local level = getLevel()
    level:add(coroutineEntity)
    coroutineEntity:add(monocle.Coroutine(celeste.CutsceneEntity.CameraTo(vector2(2034, -10), 2)))
    coroutineEntity:add(monocle.Coroutine(level:ZoomTo(vector2(144, 102), 1.5, 2)))
    coroutineEntity:add(monocle.Coroutine(wait(0.5)))
    playSprite("duck")
    wait(0.2)
    say("DIA_COMEANDSEE_BRIDGE_A")
    coroutine.yield(engine.Scene:ZoomBack(1))
    wait(1)
    wait(0.2)
    
    setFlag("flag_doBird3", true)
    wait(1.3)
    setFlag("flag_doBirdDisappear_3", true)
    wait(0.03)
    setFlag("flag_doBirdDisappear_Real3", true)
    wait(2)
    player.DummyAutoAnimate = true
    enableMovement()
    endCutscene()
end


function onEnd(room, wasSkipped)
    if wasSkipped then
    enableMovement()
    setFlag("flag_doBird2", true)
    end
end